---
generated_at: 2026-01-27 12:59:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-npm run make-screenshot.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scripts.make-screenshot定義
- E-02: `test/e2e/puppeteer.js` - メイン処理実装（--makeフラグ処理）
- E-03: `test/e2e/deterministic-injection.js` - 決定論的テスト用スクリプト
- E-04: `test/e2e/clean-page.js` - ページクリーンアップスクリプト
- E-05: `バッチ一覧.csv` - バッチ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドは`node test/e2e/puppeteer.js --make`を実行 | E-01 | ○ |
| C-02 | --makeフラグでisMakeScreenshotがtrueになる | E-02 (lines 171-176) | ○ |
| C-03 | examples/screenshots/に保存 | E-02 (line 498) | ○ |
| C-04 | JPEG品質95%で保存 | E-02 (line 110, 498) | ○ |
| C-05 | 画像サイズ400x250ピクセル | E-02 (lines 107-108) | ○ |
| C-06 | viewScale=2で撮影後に縮小 | E-02 (lines 109, 226, 490) | ○ |
| C-07 | ポート1234でサーバー起動 | E-02 (line 95) | ○ |
| C-08 | SwiftShaderを使用してブラウザ起動 | E-02 (lines 219-224) | ○ |
| C-09 | numAttempts=2（リトライ回数） | E-02 (line 104) | ○ |
| C-10 | 例外リストを除外（引数指定時は対象） | E-02 (line 186) | ○ |
| C-11 | --webgpuフラグと組み合わせ可能 | E-02 (lines 164-167, 202) | ○ |
| C-12 | 引数でexample名を指定可能 | E-02 (lines 178-181) | ○ |
| C-13 | 未認識example名は警告出力 | E-02 (lines 188-200) | ○ |
| C-14 | 決定論的スクリプトを注入 | E-02 (lines 240-243, 300) | ○ |
| C-15 | Math.random、Date.now、performance.nowを固定 | E-03 | ○ |
| C-16 | GUIとStats.jsを非表示化 | E-04 | ○ |
| C-17 | 成功時は緑色でログ出力 | E-02 (lines 113, 500) | ○ |
| C-18 | 生成完了サマリーを出力 | E-02 (lines 278-280) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - test-e2eの--makeオプションと同一処理
- 0: 低リスク - 出力先・画像品質など全パラメータがコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 生成されたスクリーンショットが適切な品質であるか確認
- [ ] 新規exampleのスクリーンショットがexamples/screenshots/に保存されたか確認
